#include <iostream>
#include <stack>
#include <string>
#include <vector>

using namespace std;

typedef long long ll;
typedef long double ld;
typedef unsigned long long ull;

#define PI 3.1415926535897932384626433832795

const int INF = 1e9;
const ll LINF = 1e18;

const ll MOD = 1000000007;
const ll FMOD = 998244353;

const ld eps = 1e-9;

vector<char> acceptable_symbols = {
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm',
    'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
};

bool check_content(char ch) {
  for (int i = 0; i < acceptable_symbols.size(); i++) {
    if (acceptable_symbols[i] == ch) {
      return true;
    }
  }

  return false;
}

bool isOpening(string tag) {
  if (tag[1] == '/') {
    return false;
  }

  return true;
}

int main() {
  ios_base::sync_with_stdio(NULL);
  cin.tie(NULL);
  cout.tie(NULL);

  string s;
  cin >> s;
  stack<string> opening_tags;

  bool flag = true;
  while (flag) {
    int first = s.find('<');

    if (first == string::npos || first != 0) {
      flag = false;
      break;
    }

    string tag = "";

    int i;
    for (i = first; i < s.size() && s[i] != '>'; i++) {
      if (check_content(s[i]) || i == first || i == first + 1) {
        tag += s[i];
      } else {
        flag = false;
        break;
      }
    }
    if (s[i] == '>') {
      tag += '>';
    }

    // cout << tag << '\n';

    if (isOpening(tag)) {
      opening_tags.push(tag);
    } else {
      if (tag.size() < 4 || opening_tags.size() == 0) {
        flag = false;
        break;
      }

      string without_closing = tag.substr(0, 1) + tag.substr(2, tag.size());
      if (opening_tags.top() == without_closing) {
        opening_tags.pop();
      } else {
        flag = false;
        break;
      }
    }

    if (i >= s.size() - 1) {
      break;
    } else {
      s = s.substr(i + 1, s.size() - i);
    }
  }

  if (flag) {
    cout << "Yes";
  } else {
    cout << "No";
  }

  return 0;
}
